<?php
/*
 * Copyright 2014 Osclass
 * Copyright 2021 Osclass by OsclassPoint.com
 *
 * Osclass maintained & developed by OsclassPoint.com
 * You may not use this file except in compliance with the License.
 * You may download copy of Osclass at
 *
 *     https://osclass-classifieds.com/download
 *
 * Do not edit or add to this file if you wish to upgrade Osclass to newer
 * versions in the future. Software is distributed on an "AS IS" basis, without
 * warranties or conditions of any kind, either express or implied. Do not remove
 * this NOTICE section as it contains license information and copyrights.
 */


  // meta tag robots
  if( osc_item_is_spam() || osc_premium_is_spam() ) {
    osc_add_hook('header','sigma_nofollow_construct');
  } else {
    osc_add_hook('header','sigma_follow_construct');
  }

  //osc_enqueue_script('fancybox');
  //osc_enqueue_style('fancybox', osc_current_web_theme_url('js/fancybox/jquery.fancybox.css'));
  osc_enqueue_style('fancybox', 'https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css');
  osc_enqueue_script('jquery-validate');

  sigma_add_body_class('item');
  osc_add_hook('after-main','sidebar');
  function sidebar(){
    osc_current_web_theme_path('item-sidebar.php');
  }

  $location = array();
  if( osc_item_city_area() !== '' ) {
    $location[] = osc_item_city_area();
  }
  if( osc_item_city() !== '' ) {
    $location[] = osc_item_city();
  }
  if( osc_item_region() !== '' ) {
    $location[] = osc_item_region();
  }
  if( osc_item_country() !== '' ) {
    $location[] = osc_item_country();
  }

  osc_current_web_theme_path('header.php');
?>

<div id="item-content">
  <h1><?php echo osc_item_title(); ?></h1>

  <?php if( osc_price_enabled_at_items() ) { ?><div class="price price-alt isMobile"><?php echo osc_item_formated_price(); ?></div><?php } ?>

  <div class="item-header">
    <div><?php if ( osc_item_pub_date() !== '' ) { printf( __('<strong class="publish">Published date:</strong> %1$s', 'sigma'), osc_format_date( osc_item_pub_date() ) ); } ?></div>
    <div><?php if ( osc_item_mod_date() !== '' ) { printf( __('<strong class="update">Modified date:</strong> %1$s', 'sigma'), osc_format_date( osc_item_mod_date() ) ); } ?></div>
    <?php if (count($location)>0) { ?>
      <ul id="item_location">
        <li><strong><?php _e("Location", 'sigma'); ?>:</strong> <?php echo implode(', ', $location); ?></li>
      </ul>
    <?php }; ?>

    <?php if(osc_is_web_user_logged_in() && osc_logged_user_id()==osc_item_user_id()) { ?>
      <p id="edit_item_view">
        <strong>
          <a href="<?php echo osc_item_edit_url(); ?>" rel="nofollow"><?php _e('Edit item', 'sigma'); ?></a>
        </strong>
      </p>
    <?php } ?>
  </div>


  <?php if( osc_images_enabled_at_items() ) { ?>
    <?php
    if( osc_count_item_resources() > 0 ) {
      $i = 0;
    ?>
    <div class="item-photos">
      <a href="javascript:;" data-fancybox-trigger="gallery" class="main-photo" title="<?php _e('Image', 'sigma'); ?> <?php echo $i+1;?> / <?php echo osc_count_item_resources();?>">
        <img src="<?php echo osc_resource_url(); ?>" alt="<?php echo osc_item_title(); ?>" title="<?php echo osc_item_title(); ?>" />
      </a>
      <div class="thumbs">
        <?php for ( $i = 0; osc_has_item_resources(); $i++ ) { ?>
        <a href="<?php echo osc_resource_url(); ?>" data-fancybox="gallery" class="fancybox" title="<?php _e('Image', 'sigma'); ?> <?php echo $i+1;?> / <?php echo osc_count_item_resources();?>">
          <img src="<?php echo osc_resource_thumbnail_url(); ?>" width="75" alt="<?php echo osc_item_title(); ?>" title="<?php echo osc_item_title(); ?>" />
        </a>
        <?php } ?>
      </div>
    </div>
    <?php } ?>
  <?php } ?>
  <div id="description">
    <div class="desc"><?php echo osc_item_description(); ?></div>

    <?php if( osc_count_item_meta() >= 1 ) { ?>
      <div id="custom_fields">
        <div class="meta_list">
          <?php while ( osc_has_item_meta() ) { ?>
            <?php if(osc_item_meta_value()!='') { ?>
              <div class="meta">
                <strong><?php echo osc_item_meta_name(); ?>:</strong> <span><?php echo osc_item_meta_value(); ?></span>
              </div>
            <?php } ?>
          <?php } ?>
        </div>
      </div>
    <?php } ?>
<p class="contact_button">
      <?php if( !osc_item_is_expired () && 1==2) { ?>
        <?php if( !( ( osc_logged_user_id() == osc_item_user_id() ) && osc_logged_user_id() != 0 ) ) { ?>
          <?php if(osc_reg_user_can_contact() && osc_is_web_user_logged_in() || !osc_reg_user_can_contact() ) { ?>
            <a href="#contact-in" class="resp-toogle btn btn-secondary show-contact-btn"><?php _e('Contact seller', 'sigma'); ?></a>
          <?php } ?>
        <?php } ?>
      <?php } ?>

      <a class="isDesktop isTablet btn btn-secondary"><?php _e('Contact seller', 'sigma'); ?></a>
    </p>
    <div class="item-hook"><?php osc_run_hook('item_detail', osc_item() ); ?></div>
    <?php if ( osc_item_contact_phone() != '' && osc_item_show_phone()) { ?>
      <p class="phone bld"><span><?php _e('Phone', 'sigma'); ?>:</span> <?php echo '<a href="tel:' . osc_item_contact_phone(true) . '">' .osc_item_contact_phone(false) . '</a>'; ?></p>
    <?php } ?>
  
<a class="whatsapp" title="<?php echo osc_esc_html(__('Whatsapp Chat', 'beta')); ?>" target="_blank" href="https://wa.me/<?php echo osc_item_contact_phone() ; ?>"><i class="fa fa-whatsapp fa-5x"></i></a>
 </div>

        <?php osc_run_hook('location'); ?>
  </div>
  <!-- plugins -->


  <?php related_listings(); ?>
  <?php if( osc_count_items() > 0 ) { ?>
    <div class="similar_ads">
      <h2><?php _e('Related listings', 'sigma'); ?></h2>
      <?php
        View::newInstance()->_exportVariableToView("listType", 'items');
        View::newInstance()->_exportVariableToView("listClass", 'listing-grid');

        osc_current_web_theme_path('loop.php');
      ?>
      <div class="clear"></div>
    </div>
  <?php } ?>


 
</script>
<?php osc_current_web_theme_path('footer.php') ; ?>