<?php
/*
  Plugin Name: Auto-Language Plugin
  Plugin URI: https://osclasspoint.com/
  Description: Plugin detects language of user browser and if available, switch osclass to this language
  Version: 1.0.0
  Author: MB Themes
  Author URI: https://osclasspoint.com
  Author Email: info@osclasspoint.com
  Short Name: auto_language
  Plugin update URI: auto-language
  Support URI: https://forums.osclasspoint.com/free-plugins/
  Product Key: 4Ru93z0aGeUifioD2FZF
*/


// DETECT BROWSER LANGUAGE AND DO REDIRECT, IF POSSIBLE
function alg_check_language() {
  if(!defined('OC_ADMIN') || (defined('OC_ADMIN') && OC_ADMIN !== true)) {
    if(Params::getParam('algRdr') != 1) {
      $browser = alg_browser_langs();
      $browser_2char = alg_browser_langs(2);

      if($browser !== false && $browser != '') {
        if(!isset($_COOKIE['algLangChecked'])) {
          $locales = OSCLocale::newInstance()->listAllEnabled();
          $current = osc_current_user_locale();
        
          if(is_array($locales) && count($locales) > 1 && ($browser != $current)) {
            foreach($locales as $loc) {
              if($browser == $loc['pk_c_code']) {
                alg_save_cookies($loc['pk_c_code']);
                header('Location:' . osc_base_url() . 'index.php?page=language&algRdr=1&locale=' . $loc['pk_c_code']);
                exit;
              }
            }
            
            // 5 char length not matched, try based on first 2 chars
            foreach($locales as $loc) {
              if($browser_2char == substr($loc['pk_c_code'], 0, 2)) {
                alg_save_cookies(substr($loc['pk_c_code'], 0, 2) . ' (' . $loc['pk_c_code'] . ')');
                header('Location:' . osc_base_url() . 'index.php?page=language&algRdr=1&locale=' . $loc['pk_c_code']);
                exit;
              }
            }
          }
          
          // No matching language found
          alg_save_cookies('--');
        }
      }
    }
  }
}

osc_add_hook('init', 'alg_check_language', 1);


// GET LANGUAGES LIST FROM BROWSER
function alg_browser_langs($length = 5) {
  $lang = alg_client_pref_lang(false, false);
  $lang = str_replace('-', '_', $lang);
  
  if(trim($lang) == '') {
    return false;
  }
  
  if($length == 5) {
    if(strlen($lang) != 5) {
      $locale = strtolower(substr($lang, 0, 2)) . '_' . strtoupper(substr($lang, 0, 2));
    } else {
      $larr = explode('_', $lang);
      $locale = strtolower($larr[0]) . '_' . strtoupper(isset($larr[1]) ? $larr[1] : $larr[0]);
    }
  } else {
    $locale = strtolower(substr($lang, 0, $length));  // expected $length = 2
  }
  
  return $locale;  
}


// GET CLIENT PREFERED LANGUAGE
function alg_client_pref_lang($sorted = false, $lang_list = false) {
  if (empty($lang_list)) {
    $lang_list = $_SERVER["HTTP_ACCEPT_LANGUAGE"];
  }

  preg_match_all('/([a-z]{1,8}(-[a-z]{1,8})*)\s*(;\s*q\s*=\s*(1|0\.[0-9]+))?/i', $lang_list, $lang_parse);
  $langs = $lang_parse[1];
  $ranks = $lang_parse[4];

  $lang2pref = array();
  for($i=0; $i<count($langs); $i++) {
    $lang2pref[$langs[$i]] = (float) (!empty($ranks[$i]) ? $ranks[$i] : 1);
  }

  $cmpLangs = function ($a, $b) use ($lang2pref) {
    if ($lang2pref[$a] > $lang2pref[$b])
      return -1;
    elseif ($lang2pref[$a] < $lang2pref[$b])
      return 1;
    elseif (strlen($a) > strlen($b))
      return -1;
    elseif (strlen($a) < strlen($b))
      return 1;
    else
      return 0;
  };

  uksort($lang2pref, $cmpLangs);

  if ($sorted) {
    return $lang2pref;
  }

  // return the first value's key
  reset($lang2pref);
  return key($lang2pref);
}

// STORE VALUE IN COOKIES
function alg_save_cookies($lang_selected) {
  $browser_langs = str_replace(',', '_', str_replace(';', '_', str_replace('=', '', $_SERVER["HTTP_ACCEPT_LANGUAGE"])));
  
  setcookie('algLangChecked', true, time()+(86400 * 30), '/');     // 30 days    
  setcookie('algLangBrowser', $browser_langs, time()+(86400 * 30), '/');
  setcookie('algLangSelected', $lang_selected, time()+(86400 * 30), '/');
}
?>